local utils = {_TYPE='module', _NAME='utils', _VERSION='0.1.0'}

function utils.clamp(value, min, max)
  if value <= min then value = min end
  if value >= max then value = max end
  return value
end

function utils.shallowcopy(orig)
  local orig_type = type(orig)
  local copy
  if orig_type == 'table' then
      copy = {}
      for orig_key, orig_value in pairs(orig) do
          copy[orig_key] = orig_value
      end
  else -- number, string, boolean, etc
      copy = orig
  end
  return copy
end

function utils.deepcopy(orig)
  local orig_type = type(orig)
  local copy
  if orig_type == 'table' then
      copy = {}
      for orig_key, orig_value in next, orig, nil do
          copy[utils.deepcopy(orig_key)] = utils.deepcopy(orig_value)
      end
      setmetatable(copy, utils.deepcopy(getmetatable(orig)))
  else -- number, string, boolean, etc
      copy = orig
  end
  return copy
end

function utils.contains(list, element)
  if list == nil or element == nil or #list == 0 then
      return false
  end
  if type(element) == "number" or type(element) == "string" then
    for i = 1, #list do
      if list[i] == element then
        return true
      end
    end
  elseif #element ~= 0 then -- `element` is a list, checking if at least one of the elements in `element` is in `list`
    for i = 1, #list do
      for k = 1, #element do
        if list[i] == element[k] then
          return true
        end
      end
    end
  end
  return false
end

return utils
