local error_handling = {_TYPE='module', _NAME='error_handling', _VERSION='0.0.1'}

function error_handling.process_error(operation_error)
  local result = {}
  if operation_error.type == "command_not_possible_rejected" then
    if operation_error.robot_mode_type == "emergency_mode" or
           operation_error.robot_mode_type == "user_stop_mode" then
      result.error_cause = "Robot is not operational. " ..
                           "Please unlock joints and enable activation device. "
    elseif operation_error.robot_mode_type == "error_recovery_mode" or
           operation_error.robot_mode_type == "folding_mode" then
      result.error_cause = "Robot is currently responding to user input. " ..
                           "Please wait for robot to stand still."
    elseif operation_error.robot_mode_type == "guiding_mode" then
      result.error_cause = "Robot is currently being guided by the user. " ..
                           "Please stop guiding before starting to run the task."
    elseif operation_error.robot_mode_type == "force_mode" or
           operation_error.robot_mode_type == "move_mode" or
           operation_error.robot_mode_type == "move_force_mode" then
      result.error_cause = "Robot is currently moving and cannot execute the requested action. " ..
                           "Please stop the robot before starting to run the task."
    elseif operation_error.robot_mode_type == "move_fci_mode" then
      result.error_cause = "Robot is currently controlled by FCI. " ..
                           "Please stop the FCI before starting to run a task."
    end
  elseif operation_error.type == "reflex_aborted" then
    result.error_cause = operation_error.reflex_reason_message
  end
  if result.error_cause == nil then
    result.error_cause = operation_error.message
  end
  result.error_codes = {{"robot", operation_error.type, operation_error.robot_mode_type, operation_error.reflex_reason_type}}
  return result
end

function error_handling.error_code_equals(e1, e2)
  if #e1 ~= #e2 then return false end
  for i, v in pairs(e1) do
    if v ~= e2[i] then
      return false
    end
  end
  return true
end

return error_handling
