set(OPEN62541_VERSION 4038a31)

if(NOT OPEN62541_SOURCE_DIR)
  message(FATAL_ERROR "OPEN62541_SOURCE_DIR not given")
endif()
if(NOT OPEN62541_BINARY_DIR)
  message(FATAL_ERROR "OPEN62541_BINARY_DIR not given")
endif()
if(NOT CMAKE_BUILD_TYPE)
  message(FATAL_ERROR "CMAKE_BUILD_TYPE not given")
endif()
if(NOT CMAKE_GENERATOR)
  message(FATAL_ERROR "CMAKE_GENERATOR not given")
endif()

configure_file(${CMAKE_CURRENT_LIST_DIR}/Open62541-CMakeLists.txt.in
  ${OPEN62541_SOURCE_DIR}/CMakeLists.txt)
execute_process(COMMAND ${CMAKE_COMMAND} -G "${CMAKE_GENERATOR}" .
  RESULT_VARIABLE result
  WORKING_DIRECTORY ${OPEN62541_SOURCE_DIR}
)
if(result)
  message(FATAL_ERROR "Running CMake for Open62541 failed: ${result}")
endif()

execute_process(COMMAND ${CMAKE_COMMAND} --build .
  RESULT_VARIABLE result
  WORKING_DIRECTORY ${OPEN62541_SOURCE_DIR}
)
if(result)
  message(FATAL_ERROR "Downloading Open62541 failed: ${result}")
endif()
